% to create an example of the LWA using FOUs from the survey.
% Dongrui WU (dongruiw@usc.edu), 5/12/2008

clear all;
close all;
clc;

%% get the FOUs
[words,MFs]=getFOUs();

%% -------- Plot the ordered interval type-2 word models in a single figure ----
%% Plot the ordered interval type-2 word models
figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',7);
for i=1:32
    subplot(8,6,2*floor((i-1)/4)+i);
    fill(MFs(i,[1:4 8 7 6 5 1]),[0 1 1 0 0 MFs(i,9) MFs(i,9) 0 0],[0.9 0.9 0.9]);
    hold on;
    plot(MFs(i,1:4),[0 1 1 0],'k','linewidth',1);
    plot(MFs(i,5:8),[0 MFs(i,9) MFs(i,9) 0],'k','linewidth',1);
    title(words(i,:),'fontsize',7);
    set(gca,'YTick',[]);
    set(gca,'XTick',[]);
    axis([0 10 0 1]);
end

Xs=[4 8 19]; %[tiny,little, sizeable]
Ws=[10 16 26]; %[small, medium, large]
LWA=LWA9(MFs(Xs,:),MFs(Ws,:)); %% LWA
for i=1:size(words,1)
    S(i)=Jaccard(LWA,MFs(i,:));
end
[maxS,index]=max(S);
decode=words(index,:)  %% decoding
maxS

figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',12);
set(gcf,'DefaultlineLineWidth',1);
set(gcf,'DefaultaxesLineWidth',1);
subplot(3,1.5,1)
N=length(Xs);
for i=1:N
    fill(MFs(Xs(i),[1:4 8:-1:5]),[0 1 1 0 0 MFs(Xs(i),[9 9]) 0],[0.9,0.9,0.9]);
    hold on
end
for i=1:N
    plot(MFs(Xs(i),[1:4 8:-1:5]),[0 1 1 0 0 MFs(Xs(i),[9 9]) 0],'linewidth',1.5);
    text(MFs(Xs(i),2)-.8, 1.15, words(Xs(i),:));
end
axis([0,11,0,1.4]);
set(gca,'xtick',[0:10]);
box off
text(11.2,0,'x');
text(0.2,1.33,'u');
arrow([0,0],[11,0],0.1,pi/10,0.5,[0 0 0],'-');
arrow([0,0.8],[0,1.4],0.1,pi/9,0.5,[0 0 0],'-');
saveas(gcf,'LWAx2.eps');

figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',12);
set(gcf,'DefaultlineLineWidth',1);
set(gcf,'DefaultaxesLineWidth',1);
subplot(3,1.5,1)
for i=1:N
    fill(MFs(Ws(i),[1:4 8:-1:5]),[0 1 1 0 0 MFs(Ws(i),[9 9]) 0],[0.9,0.9,0.9]);
    hold on
end
for i=1:N
    plot(MFs(Ws(i),[1:4 8:-1:5]),[0 1 1 0 0 MFs(Ws(i),[9 9]) 0],'linewidth',1.5);
    text(mean(MFs(Ws(i),2:3))-1.5, 1.15, words(Ws(i),:));
end
axis([0,11,0,1.4]);
set(gca,'xtick',[0:10]);
box off
text(11.2,0,'w');
text(0.2,1.33,'u');
arrow([0,0],[11,0],0.1,pi/10,0.5,[0 0 0],'-');
arrow([0,0.8],[0,1.4],0.1,pi/9,0.5,[0 0 0],'-');
saveas(gcf,'LWAw2.eps');

figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',12);
set(gcf,'DefaultlineLineWidth',1);
set(gcf,'DefaultaxesLineWidth',1);
subplot(3,1.5,1)
fill(LWA([1:4 8:-1:5]),[0 1 1 0 0 LWA([9 9]) 0],[0.9,0.9,0.9]);
hold on
fill(MFs(index,[1:4 8:-1:5]),[0 1 1 0 0 MFs(index,[9 9]) 0],[0.9,0.9,0.9]);
plot(LWA([1:4 8:-1:5]),[0 1 1 0 0 LWA([9 9]) 0],'linewidth',1.5);
plot(MFs(index,[1:4 8:-1:5]),[0 1 1 0 0 MFs(index,[9 9]) 0],'--','linewidth',1.5);
axis([0, 11, 0, 1.4]);
text('Interpreter','latex','String','$$\widetilde{Y}_{LWA}$$','Position',[LWA(2)+.2,1.15]);
axis([0,11,0,1.4]);
set(gca,'xtick',[0:10]);
box off
text(11.2,0,'y');
text(0.2,1.3,'u');
arrow([0,0],[11,0],0.1,pi/10,0.5,[0 0 0],'-');
arrow([0,0.8],[0,1.4],0.1,pi/10,0.5,[0 0 0],'-');
saveas(gcf,'LWAy2.eps');

